﻿using gov.va.med.vbecs.Common;
using System;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// Blood Unit Data Access Object
    /// </summary>
    public class BloodUnitDao : IBloodUnitDao
    {
        /// <summary>
        /// BloodUnitGuid
        /// </summary>
        public Guid BloodUnitGuid { get; set; }
        /// <summary>
        /// BloodUnitGuid
        /// </summary>
        public Guid BloodUnitStatusGuid { get; set; } 
        /// <summary>
        /// UnitProductCode
        /// </summary>
        public string UnitProductCode { get; set; }
        /// <summary>
        /// ProductShortName
        /// </summary>
        public string ProductShortName { get; set; }
        /// <summary>
        /// ProductTypeSortColumn
        /// </summary>
        public short ProductTypeSortColumn { get; set; }
        /// <summary>
        /// OriginalVolume
        /// </summary>
        public decimal? OriginalVolume { get; set; }
        /// <summary>
        /// DiscardedPlasmaVolume
        /// </summary>
        public decimal? DiscardedPlasmaVolume { get; set; }
        /// <summary>
        /// PooledUnitsCount
        /// </summary>
        public int PooledUnitsCount { get; set; }
        /// <summary>
        /// UnitInDate
        /// </summary>
        public DateTime UnitInDate { get; set; }
        /// <summary>
        /// UnitFdaRegistrationNumber
        /// </summary>
        public string UnitFdaRegistrationNumber { get; set; }
        /// <summary>
        /// UnitContainerLotNumber
        /// </summary>
        public string UnitContainerLotNumber { get; set; }
        /// <summary>
        /// DonationTypeID
        /// </summary>
        public int? DonationTypeId { get; set; }
        /// <summary>
        /// DonationTypeCode
        /// </summary>
        public string DonationTypeCode { get; set; }
        /// <summary>
        /// UnitDivisionID
        /// </summary>
        public string UnitDivisionId { get; set; }
        /// <summary>
        /// LabelTypeCode
        /// </summary>
        public string LabelTypeCode { get; set; }
        /// <summary>
        /// LabelUnitID
        /// </summary>
        public string LabelUnitId { get; set; }
        /// <summary>
        /// EyeReadableUnitID
        /// </summary>
        public string EyeReadableUnitId { get; set; }
        /// <summary>
        /// BloodProductGUID
        /// </summary>
        public Guid BloodProductGuid { get; set; }
        /// <summary>
        /// IncomingShipmentGuid
        /// </summary>
        public Guid? IncomingShipmentGuid { get; set; }
        /// <summary>
        /// DivisionCode
        /// </summary>
        public string DivisionCode { get; set; }
        /// <summary>
        /// EntryMethodCode
        /// </summary>
        public string EntryMethodCode { get; set; }
        /// <summary>
        /// ProcessingTechID
        /// </summary>
        public string ProcessingTechId { get; set; }
        /// <summary>
        /// RecordStatusCode
        /// </summary>
        public string RecordStatusCode { get; set; }
        /// <summary>
        /// LastUpdateDate
        /// </summary>
        public DateTime LastUpdateDate { get; set; }
        /// <summary>
        /// LastUpdateUser
        /// </summary>
        public string LastUpdateUser { get; set; }
        /// <summary>
        /// PendingTransferIndicator
        /// </summary>
        public bool PendingTransferIndicator { get; set; }
        /// <summary>
        /// BloodTypeCode
        /// </summary>
        public string BloodTypeCode { get; set; }
        /// <summary>
        /// RhFactorText
        /// </summary>
        public string RhFactorText { get; set; }
        /// <summary>
        /// BloodUnitStatusRowVersion
        /// </summary>
        public byte[] BloodUnitStatusRowVersion { get; set; }
        /// <summary>
        /// UnitStatusCode
        /// </summary>
        public string UnitStatusCode { get; set; } 
    }
}
